' https://support.brightsign.biz/hc/en-us/articles/360046935113-Creating-an-autorun-zip
Sub Main()

m.fusionGlobal = CreateObject("roAssociativeArray")
m.fusionGlobal.settings = CreateObject("roAssociativeArray")
msgPort = CreateObject("roMessagePort")

' get screen resolution
vm=CreateObject("roVideoMode")
m.fusionGlobal.width=vm.GetResX()
m.fusionGlobal.height=vm.GetResY()
touchScreen = CreateObject("roTouchScreen")
touchScreen.EnableCursor(false)

m.fusionGlobal.systemTime = CreateObject("roSystemTime")

' support for firmware < 7.0.x  - https://docs.brightsign.biz/display/DOC/Node.js
rs = createobject("roRegistrySection", "html")
multiProcess = rs.read("mp")
if multiProcess <> "1" then
    rs.write("mp","1")
    rs.flush()
    RebootSystem()
endif

' Use BrightSign for video playback (as opposed to Chromium). Review FUS-750 to understand this decision.
' https://brightsign.atlassian.net/wiki/spaces/DOC/pages/1348304996/HTML+Playback+Options+on+Series+5+Players
rs.Write("use-brightsign-media-player", "1")
rs.Flush()

disableHttpCache = rs.Read("disable-http-cache")
if disableHttpCache <> "1" then
    rs.Write("disable-http-cache", "1")
    rs.Flush()
    RebootSystem()
endif

firstMountedStoragePath = GetFirstMountedStoragePath()

config = {
    url: "file:///dist/index.html",
    security_params: {
        websecurity: false
    },
    nodejs_enabled: true,
    brightsign_js_objects_enabled: true,
    mouse_enabled: true,
    storage_path: firstMountedStoragePath,
    storage_quota: 1073741824,
    inspector_server: {
        port: 2999
    },
    port: msgPort,
    ' Enable hardware video rendering by default
    ' https://brightsign.atlassian.net/wiki/spaces/DOC/pages/370672326/HTML+Video#HWZ-Video
    hwz_default: "on"
}

rect = CreateObject("roRectangle", 0, 0, m.fusionGlobal.width, m.fusionGlobal.height)
m.fusionGlobal.htmlWidget = CreateObject("roHtmlWidget", rect, config)
' h.AllowJavaScriptUrls({ all: "*" })
m.fusionGlobal.htmlWidget.Show()

m.fusionGlobal.ethernet = CreateObject("roNetworkConfiguration", "eth0")
m.fusionGlobal.wifi = CreateObject("roNetworkConfiguration", "wlan0")

ReadSettings()

' https://docs.brightsign.biz/display/DOC/Events
while true
    msg = wait(0, msgPort)
    if type(msg) = "roHtmlWidgetEvent" then
        LogMessage("message received")
        eventData = msg.GetData()
        LogMessage(eventData.reason)
        if type(eventData) = "roAssociativeArray" and type(eventData.reason) = "roString" then
        ' object values being turned to strings
        ' network object is stringified on client and parsed here for this reason
            if eventData.reason = "load-error" then
                LogMessage(eventData.message)
            end if
            if eventData.reason = "message" then
                commandId = eventData.message.id
                evCommand = eventData.message.command
                LogMessage(evCommand)
                if evCommand = "reboot" then
                    RebootSystem()
                end if
                if evCommand = "setCursorVisible" then
                    touchScreen.EnableCursor(true)
                end if
                if evCommand = "setCursorHidden" then
                    touchScreen.EnableCursor(false)
                end if
                if evCommand = "setScreenRotation" then
                    rotation = eventData.message.rotation
                    if rotation <> invalid then
                        SetRotation(rotation)
                    end if
                end if
                if evCommand = "setTimezone" then
                    timezone = eventData.message.timezone
                    if timezone <> invalid then
                        SetDateTime(timezone)
                    end if
                end if
                if evCommand = "setNetwork" then
                    SetNetwork(ParseJson(eventData.message.network))
                end if
                if evCommand = "loaded" then
                    if m.fusionGlobal.settings <> invalid then
                        settings = FormatJson(m.fusionGlobal.settings)
                        m.fusionGlobal.htmlWidget.PostJSMessage({ message: "settings", data: settings })
                    end if
                end if
            end if
        end if
    end if
end while

End Sub

' FormatJson() - if you want to pass an object (associative array)
Sub LogMessage(message as string)
    slog = createobject("roSystemLog")
    slog.sendline("FUSION: " + message)
End Sub

' datetime logic extracted/inspired by the script in this article
' https://brightsign.zendesk.com/hc/en-us/articles/360021514593-How-do-I-set-the-Time-or-Timezone-on-a-BrightSign-player-in-BrightAuthor-connected-#:~:text=Using%20the%20Remote%20DWS%20(Scope%20%2B%20info)%3A&text=Access%20the%20Remote%20Diagnostic%20Web,current%20time%20on%20the%20player
Sub SetDateTime(timezone as string)
    'm is kinda like 'this'
    m.fusionGlobal.systemTime.SetTimeZone(timezone)
    RebootSystem()
End Sub

Sub SetNetwork(network as Object)
    if network.manual = false then
        ' SetDHCP() will override any network settings
        m.fusionGlobal.ethernet.SetDHCP()
    end if
    if network.manual = true then
        if network.type = "ethernet" then
            if network.ipAddress <> "" then
                m.fusionGlobal.ethernet.SetIp4Address(network.ipAddress)
            end if
            if network.subnetMask <> "" then
                m.fusionGlobal.ethernet.SetIp4Netmask(network.subnetMask)
            end if
            if network.defaultGateway <> "" then
                m.fusionGlobal.ethernet.SetIP4Gateway(network.defaultGateway)
            end if
            if network.broadcastAddress <> "" then
                m.fusionGlobal.ethernet.SetIP4Broadcast(network.broadcastAddress)
            end if
            if network.dns <> "" then
                m.fusionGlobal.ethernet.AddDNSServer(network.dns)
            end if
            result = m.fusionGlobal.ethernet.Apply()
        end if
        if network.type = "wifi" then
            m.fusionGlobal.wifi.SetWiFiESSID(network.ssid)
            ' Configures the WiFi ESSID of the wireless network that the player will connect to. This method returns true on success.

            m.fusionGlobal.wifi.SetWiFiPassphrase(network.password)
            ' Configures the passphrase or key for the wireless network. This method accepts a plain-text passphrase. It returns true if the passphrase is successfully set.
            m.fusionGlobal.wifi.Apply()
        end if
    end if
End Sub


' settings file is read and settings saved to m.fusionGlobal.settings
' in message handler they are sent to the client which persists them in `localStorage.json`
Function ReadSettings()
    m.fusionGlobal.settings = ParseJson(ReadAsciiFile("settings.json"))
    if m.fusionGlobal.settings = invalid then
        return null
    end if
    if m.fusionGlobal.settings.screenRotation <> invalid then
        SetRotation(m.fusionGlobal.settings.screenRotation)
    end if
    if m.fusionGlobal.settings.timezone.brightsign <> invalid then
        m.fusionGlobal.systemTime.SetTimeZone(m.fusionGlobal.settings.timezone.brightsign)
    end if
    if m.fusionGlobal.settings.screenDimensions.enabled = false then
        ' set sane defaults so that when enabled the application is usable 
        m.fusionGlobal.settings.screenDimensions.height = m.fusionGlobal.height
        m.fusionGlobal.settings.screenDimensions.width = m.fusionGlobal.width
    end if
    SetNetwork(m.fusionGlobal.settings.network)
    DeleteFile("settings.json")
    ' other settings are handled by message handler above which sends them to the client
End Function

Sub SetRotation(rotation as string) 
    if rotation = "0" then
        m.fusionGlobal.htmlWidget.SetTransform("identity")
    else if rotation = "90" then
        m.fusionGlobal.htmlWidget.SetTransform("rot90")
    else if rotation = "180" then
        m.fusionGlobal.htmlWidget.SetTransform("rot180")
    else if rotation = "270" then
        m.fusionGlobal.htmlWidget.SetTransform("rot270")
    end if
End Sub

Function GetFirstMountedStoragePath()
    ' https://brightsign.atlassian.net/wiki/spaces/DOC/pages/1937866753/Player+Provisioning+and+Recovery+System+Requirements#Storage-Status-Parameters
    destinationPaths = ["SD:", "SD2:", "SSD:", "USB1:"]
    for each destination in destinationPaths
        if IsMounted(destination) then
            return destination
        end if
    next
    return "ERROR"
End Function

Function IsMounted(path as String)
    if CreateObject("roStorageHotplug").GetStorageStatus(path).mounted then
        return true
    end if

    return false
End Function