'name file autorun.zip
' Content update application

Sub Main()
    tempUnzipFolder$= GetTempUnzipLocation()
    if IsExists(tempUnzipFolder$) then
        DeleteDirectory(tempUnzipFolder$)
    end if
    CreateDirectory(tempUnzipFolder$)

    path$= FindDestPath()
    source$= FindSourcePath()
    package = CreateObject("roBrightPackage", source$+"autorun.zip")
    package.SetPassword("test")
    package.Unpack(tempUnzipFolder$)
    package = 0

    if IsExists(path$+"dist") then
        DeleteDirectory(path$+"dist")
    end if 
    if IsExists(path$+"autorun.brs") then
        DeleteFile(path$+"autorun.brs")
    end if 

    MoveFile(tempUnzipFolder$ + "autorun.brs", path$ + "autorun.brs")
    MoveFile(tempUnzipFolder$ + "dist", path$ + "dist")

    if IsExists(tempUnzipFolder$) then
        DeleteDirectory(tempUnzipFolder$)
    end if
    if IsExists(path$+"autorun.zip") then
        DeleteFile(path$+"autorun.zip")
    end if 
    a=RebootSystem()
End Sub

Function FindDestPath()
    return GetFirstMountedStoragePath() + "/"
End Function

Function FindSourcePath()
    sourcePaths = ["USB1:", "SD:", "SSD:"]
    for each source in sourcePaths
        if IsMounted(source) and CheckFile(source+"/autorun.zip") then
            return source+"/"
        end if
    next
    return "unknown"
End Function

Function GetTempUnzipLocation()
    return FindDestPath() + "temp_fusion/"
End Function

Function IsMounted(path as String)
    if CreateObject("roStorageHotplug").GetStorageStatus(path).mounted then
        return true
    end if

    return false
End Function

Function IsFirmwareValid()
    di = CreateObject("roDeviceInfo")
    return di.FirmwareIsAtLeast("7.0.60")
End Function

Function CheckFile(path as String)
    file = CreateObject("roReadFile", path)
    if type(file) = "roReadFile" then
        return true
    end if

    return false
End Function

Function IsExists(path as String)
    file = CreateObject("roReadFile", path)
    if type(file) = "roReadFile" then
        return true
    end if

    return false
End Function

Function GetFirstMountedStoragePath()
    ' https://brightsign.atlassian.net/wiki/spaces/DOC/pages/1937866753/Player+Provisioning+and+Recovery+System+Requirements#Storage-Status-Parameters
    destinationPaths = ["SD:", "SD2:", "SSD:", "USB1:"]
    for each destination in destinationPaths
        if IsMounted(destination) then
            return destination
        end if
    next
    return "ERROR"
End Function